/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp.data;

import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.data.CEComment;
import com.ibm.hsc.auiml.databeans.sfp.data.FRUAdditional;
import com.ibm.hsc.auiml.databeans.sfp.data.FRUNew;
import com.ibm.hsc.auiml.databeans.sfp.data.FRUOriginal;
import com.ibm.hsc.auiml.databeans.sfp.data.ManagedObject;
import com.ibm.hsc.auiml.databeans.sfp.data.ServiceableEventListener;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.common.log.ClassLogInfo;
import com.ibm.jcb.RemoteSourceException;
import com.ibm.rsct.rmc.McResource;
import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.rmcjni.McErrNumException;
import com.ibm.rsct.util.CtArray;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtRsrcHandle;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.rsct.util.CtUint32;
import com.ibm.rsct.util.CuException;
import com.ibm.websm.mobject.MOClass;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class ServiceableEvent
implements Serializable {
    private ManagedObject[] managedObjects = null;
    private CEComment[] ceComments = null;
    private FRUOriginal[] fruListOriginal = null;
    private FRUAdditional[] fruListAdditional = null;
    private int changeCounter = -1;
    private String hscId = "";
    private String hscName = "";
    private String status = "";
    private String errLogLabel = "";
    private boolean callHomeCandidate = false;
    private boolean calledHome = false;
    private CEComment ceCommentsNew = null;
    private FRUNew fruNew = null;
    private String ptrHscEED = "";
    private String earliestOriginalTimestamp = "";
    private String latestTimestamp = "";
    private Locale hmcLocale = null;
    private int variety = -1;
    private String componentId = "";
    private String specialHandling = "";
    private CtRsrcHandle resourceHandle = null;
    private Vector listeners = new Vector();
    private static final int ID_RESOURCE_HANDLE = 0;
    private static final int ID_CHANGE_COUNTER = 1;
    private static final int ID_HSC_ID = 2;
    private static final int ID_HSC_NAME = 3;
    private static final String ATTRIBUTE_STATUS = "Status";
    private static final int ID_STATUS = 4;
    private static final int ID_ERR_LOG_LABEL = 5;
    private static final int ID_CALL_HOME_CANDIDATE = 6;
    private static final int ID_CALLED_HOME = 7;
    private static final int ID_CE_COMMENTS = 8;
    private static final String ATTRIBUTE_CE_COMMENTS_NEW = "CECommentsNew";
    private static final int ID_CE_COMMENTS_NEW = 9;
    private static final int ID_FRU_LIST = 10;
    private static final int ID_FRU_LIST_ADDITIONAL = 11;
    private static final String ATTRIBUTE_FRU_NEW = "FRUListNew";
    private static final int ID_FRU_NEW = 12;
    private static final int ID_PTR_HSC_EED = 13;
    private static final int ID_MANAGED_OBJECTS = 14;
    private static final int ID_VARIETY = 15;
    private static final int ID_NODE_LIST = 16;
    private static final int ID_COMPONENT_ID = 17;
    private static final int ID_SPECIAL_HANDLING = 18;
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String OPEN = "Open";
    public static final String CLOSED = "Closed";
    public static final int HIGHEST_UNDERSTOOD_VARIETY = 3;
    public static final String SURVEILLANCE_ERROR_CLASS = "SURVALNC";
    public static final String CUSTOMER_UPGRADE_ON_DEMAND_ERROR_CLASS = "CUOD";
    private static final String TRACE_MASKD = "JSEVENTD";
    private static final String TRACE_MASKF = "JSEVENTF";
    private static final String TRACE_MASKT = "JSEVENTT";
    private static final ClassLogInfo _logInfo = new ClassLogInfo(-88, 108, "SFPSvcbleEvt");
    private static final short ERRID_0080 = 128;

    public ServiceableEvent(McResource mcResource) throws SFPException {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.c-tor()");
        this.hmcLocale = Locale.getDefault();
        this.parseAttributes(mcResource);
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.c-tor()");
    }

    private synchronized void parseAttributes(McResource mcResource) throws SFPException {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseAttributes(McResource)");
        if (mcResource != null) {
            McAttribute[] mcAttributeArray = null;
            Exception exception = null;
            try {
                mcAttributeArray = mcResource.getAllPersistentAttributes();
            }
            catch (McErrNumException mcErrNumException) {
                exception = new Exception(mcErrNumException.getMessage());
            }
            catch (CuException cuException) {
                exception = new Exception(cuException.getMessage());
            }
            if (exception != null) {
                Trace.trace(TRACE_MASKF, "ServiceableEvent.parseAttributes() caught: " + exception);
                throw new SFPException("0001", exception);
            }
            this.parseAttributes(mcAttributeArray);
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseAttributes(McResource)");
    }

    private synchronized void parseAttributes(McAttribute[] mcAttributeArray) {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseAttributes(McAttribute[])");
        if (mcAttributeArray != null) {
            try {
                int n = 0;
                while (n < mcAttributeArray.length) {
                    McAttribute mcAttribute = mcAttributeArray[n];
                    switch (mcAttribute.getId()) {
                        case 0: {
                            this.resourceHandle = ServiceableEvent.getResourceHandleAttributeValue(mcAttribute);
                            break;
                        }
                        case 1: {
                            this.changeCounter = ServiceableEvent.getIntegerAttributeValue(mcAttribute);
                            break;
                        }
                        case 2: {
                            this.hscId = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            break;
                        }
                        case 3: {
                            this.hscName = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            break;
                        }
                        case 4: {
                            this.status = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            break;
                        }
                        case 5: {
                            this.errLogLabel = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            break;
                        }
                        case 6: {
                            this.callHomeCandidate = ServiceableEvent.getBooleanAttributeValue(mcAttribute);
                            break;
                        }
                        case 7: {
                            this.calledHome = ServiceableEvent.getIntegerAttributeValue(mcAttribute) > 0;
                            break;
                        }
                        case 8: {
                            this.parseCEComments(mcAttribute);
                            break;
                        }
                        case 9: {
                            this.ceCommentsNew = new CEComment(ServiceableEvent.getStructuredDataAttributeValue(mcAttribute));
                            break;
                        }
                        case 10: {
                            this.parseFRUListOriginal(mcAttribute);
                            break;
                        }
                        case 11: {
                            this.parseFRUListAdditional(mcAttribute);
                            break;
                        }
                        case 12: {
                            this.fruNew = new FRUNew(ServiceableEvent.getStructuredDataAttributeValue(mcAttribute));
                            break;
                        }
                        case 13: {
                            this.ptrHscEED = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            break;
                        }
                        case 14: {
                            this.parseManagedObjects(mcAttribute);
                            break;
                        }
                        case 15: {
                            this.variety = ServiceableEvent.getIntegerAttributeValue(mcAttribute);
                            break;
                        }
                        case 17: {
                            this.componentId = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            break;
                        }
                        case 18: {
                            this.specialHandling = ServiceableEvent.getStringAttributeValue(mcAttribute);
                        }
                    }
                    ++n;
                }
                this.parseTimestamps();
                this.notifyListeners();
            }
            catch (RuntimeException runtimeException) {
                new AusMicrocodeLog(_logInfo, 128, runtimeException).writeEntry(null);
                throw runtimeException;
            }
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseAttributes(McAttribute[])");
    }

    public void reset(McResource mcResource) throws SFPException {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.reset(McResource)");
        this.parseAttributes(mcResource);
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.reset(McResource)");
    }

    private void reset(ServiceableEvent serviceableEvent) {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.reset(ServiceableEvent)");
        if (serviceableEvent != null) {
            this.resourceHandle = serviceableEvent.getResourceHandle();
            this.changeCounter = serviceableEvent.getChangeCounter();
            this.hscId = serviceableEvent.getHSCId();
            this.hscName = serviceableEvent.getHSCName();
            this.status = serviceableEvent.getStatus();
            this.errLogLabel = serviceableEvent.getErrLogLabel();
            this.callHomeCandidate = serviceableEvent.isCallHomeCandidate();
            this.calledHome = serviceableEvent.isCalledHome();
            this.ceComments = serviceableEvent.getCEComments();
            this.ceCommentsNew = serviceableEvent.getCECommentsNew();
            this.fruListOriginal = serviceableEvent.getFRUListOriginal();
            this.fruListAdditional = serviceableEvent.getFRUListAdditional();
            this.fruNew = serviceableEvent.getFRUNew();
            this.ptrHscEED = serviceableEvent.getPtrHscEED();
            this.managedObjects = serviceableEvent.getManagedObjects();
            this.earliestOriginalTimestamp = serviceableEvent.getEarliestOriginalTimestamp();
            this.latestTimestamp = serviceableEvent.getLatestTimestamp();
            this.variety = serviceableEvent.getVariety();
            this.componentId = serviceableEvent.getComponentId();
            this.specialHandling = serviceableEvent.getSpecialHandling();
            this.notifyListeners();
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.reset(ServiceableEvent)");
    }

    public CtRsrcHandle getResourceHandle() {
        return this.resourceHandle;
    }

    public int getChangeCounter() {
        return this.changeCounter;
    }

    public String getHSCId() {
        return this.hscId;
    }

    public String getHSCName() {
        return this.hscName;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isOpen() {
        return OPEN.equalsIgnoreCase(this.status);
    }

    public String getErrLogLabel() {
        return this.errLogLabel;
    }

    public boolean isCallHomeCandidate() {
        return this.callHomeCandidate;
    }

    public boolean isCalledHome() {
        return this.calledHome;
    }

    public CEComment[] getCEComments() {
        return this.ceComments;
    }

    public CEComment getCECommentsNew() {
        return this.ceCommentsNew;
    }

    public FRUOriginal[] getFRUListOriginal() {
        return this.fruListOriginal;
    }

    public FRUAdditional[] getFRUListAdditional() {
        return this.fruListAdditional;
    }

    public FRUNew getFRUNew() {
        return this.fruNew;
    }

    public String getPtrHscEED() {
        return this.ptrHscEED;
    }

    public ManagedObject[] getManagedObjects() {
        return this.managedObjects;
    }

    public Locale getHMCLocale() {
        return this.hmcLocale;
    }

    public int getVariety() {
        return this.variety;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getSpecialHandling() {
        return this.specialHandling;
    }

    public boolean isFullyParsed() {
        return this.getVariety() <= 3;
    }

    public String getEarliestOriginalTimestamp() {
        return this.earliestOriginalTimestamp;
    }

    public String getLatestTimestamp() {
        return this.latestTimestamp;
    }

    private void parseTimestamps() {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseTimestamps()");
        ManagedObject[] managedObjectArray = this.getManagedObjects();
        Date date = null;
        Date date2 = null;
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < managedObjectArray.length) {
            ManagedObject managedObject = managedObjectArray[n3];
            Date date3 = managedObject.getOrigTimestampDate();
            Date date4 = managedObject.getLastTimestampDate();
            if (date4 == null) {
                date4 = date3;
            }
            if (date == null || date3 != null && date3.before(date)) {
                date = date3;
                n = n3;
            }
            if (date2 == null || date4 != null && date4.after(date2)) {
                date2 = date4;
                n2 = n3;
            }
            ++n3;
        }
        String string = this.earliestOriginalTimestamp = n > -1 ? managedObjectArray[n].getOrigTimestamp() : "";
        if (n2 == -1) {
            this.latestTimestamp = "";
        } else {
            this.latestTimestamp = managedObjectArray[n2].getLastTimestamp();
            if (this.latestTimestamp == null || this.latestTimestamp.length() == 0) {
                this.latestTimestamp = managedObjectArray[n2].getOrigTimestamp();
            }
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseTimestamps()");
    }

    private void parseManagedObjects(McAttribute mcAttribute) {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseManagedObjects()");
        CtDataType[] ctDataTypeArray = ServiceableEvent.getArrayAttributeValue(mcAttribute);
        int n = ctDataTypeArray.length;
        this.managedObjects = new ManagedObject[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                this.managedObjects[n2] = new ManagedObject((CtStructuredData)ctDataTypeArray[n2], this.hmcLocale);
            }
            catch (ClassCastException classCastException) {
                Trace.trace(TRACE_MASKF, "ServiceableEvent.parseManagedObjects() expecting CtStructuredData: " + classCastException);
                throw classCastException;
            }
            ++n2;
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseManagedObjects()");
    }

    private void parseCEComments(McAttribute mcAttribute) {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseCEComments()");
        CtDataType[] ctDataTypeArray = ServiceableEvent.getArrayAttributeValue(mcAttribute);
        int n = ctDataTypeArray.length;
        this.ceComments = new CEComment[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                this.ceComments[n2] = new CEComment((CtStructuredData)ctDataTypeArray[n2]);
            }
            catch (ClassCastException classCastException) {
                Trace.trace(TRACE_MASKF, "ServiceableEvent.parseCEComments() expecting CtStructuredData: " + classCastException);
                throw classCastException;
            }
            ++n2;
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseCEComments()");
    }

    private void parseFRUListOriginal(McAttribute mcAttribute) {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseFRUListOriginal()");
        CtDataType[] ctDataTypeArray = ServiceableEvent.getArrayAttributeValue(mcAttribute);
        int n = ctDataTypeArray.length;
        this.fruListOriginal = new FRUOriginal[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                this.fruListOriginal[n2] = new FRUOriginal((CtStructuredData)ctDataTypeArray[n2]);
            }
            catch (ClassCastException classCastException) {
                Trace.trace(TRACE_MASKF, "ServiceableEvent.parseFRUListOriginal() expecting CtStructuredData: " + classCastException);
                throw classCastException;
            }
            ++n2;
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseFRUListOriginal()");
    }

    private void parseFRUListAdditional(McAttribute mcAttribute) {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseFRUListAdditional()");
        CtDataType[] ctDataTypeArray = ServiceableEvent.getArrayAttributeValue(mcAttribute);
        int n = ctDataTypeArray.length;
        this.fruListAdditional = new FRUAdditional[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                this.fruListAdditional[n2] = new FRUAdditional((CtStructuredData)ctDataTypeArray[n2]);
            }
            catch (ClassCastException classCastException) {
                Trace.trace(TRACE_MASKF, "ServiceableEvent.parseFRUListAdditional() expecting CtStructuredData: " + classCastException);
                throw classCastException;
            }
            ++n2;
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseFRUListAdditional()");
    }

    public void updateFRUs(FRUNew[] fRUNewArray, MOClass mOClass) throws SFPException {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.updateFRUs()");
        SFPException sFPException = null;
        int n = 0;
        while (n < fRUNewArray.length) {
            FRUNew fRUNew = fRUNewArray[n];
            McAttribute mcAttribute = new McAttribute(ATTRIBUTE_FRU_NEW, 12, (CtDataType)fRUNew.getStructuredData());
            Trace.trace(TRACE_MASKF, "ServiceableEvent.updateFRUs() updating with " + fRUNew.toString());
            try {
                this.updateAttribute(mcAttribute, mOClass);
            }
            catch (SFPException sFPException2) {
                Trace.trace(TRACE_MASKF, "ServiceableEvent.updateFRUs() took exception updating attribute: " + sFPException2);
                sFPException = sFPException2;
            }
            ++n;
        }
        if (sFPException != null) {
            throw sFPException;
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.updateFRUs()");
    }

    public void updateComments(CEComment cEComment, MOClass mOClass) throws SFPException {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.updateComments()");
        McAttribute mcAttribute = new McAttribute(ATTRIBUTE_CE_COMMENTS_NEW, 9, (CtDataType)cEComment.getStructuredData());
        this.updateAttribute(mcAttribute, mOClass);
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.updateComments()");
    }

    public void closeEvent(MOClass mOClass) throws SFPException {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.closeEvent()");
        McAttribute mcAttribute = new McAttribute(ATTRIBUTE_STATUS, 4, (CtDataType)new CtString(CLOSED));
        this.updateAttribute(mcAttribute, mOClass);
        Trace.trace(TRACE_MASKF, "ServiceableEvent.closeEvent() updated status; should be closed: " + this.getStatus());
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.closeEvent()");
    }

    private void updateAttribute(McAttribute mcAttribute, MOClass mOClass) throws SFPException {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.updateAttribute()");
        Object[] objectArray = new Object[]{this.getResourceHandle(), mcAttribute};
        ServiceableEvent serviceableEvent = null;
        try {
            serviceableEvent = (ServiceableEvent)mOClass.invokeStaticMethod("updateAttribute", objectArray);
        }
        catch (SFPException sFPException) {
            Trace.trace(TRACE_MASKF, "ServiceableEvent.updateAttribute() caught and rethrowing SFPException: " + sFPException);
            throw sFPException;
        }
        catch (RemoteSourceException remoteSourceException) {
            Trace.trace(TRACE_MASKF, "ServiceableEvent.updateAttribute() caught RemoteSourceException: " + (Object)((Object)remoteSourceException));
            if (remoteSourceException.getSourceException() != null) {
                if (remoteSourceException.getSourceException() instanceof SFPException) {
                    throw (SFPException)remoteSourceException.getSourceException();
                }
                throw new SFPException("0003", remoteSourceException.getSourceException());
            }
            throw new SFPException("0003", remoteSourceException);
        }
        catch (RemoteException remoteException) {
            Trace.trace(TRACE_MASKF, "ServiceableEvent.updateAttribute() caught RemoteException: " + remoteException);
            if (remoteException.detail != null) {
                if (remoteException.detail instanceof SFPException) {
                    throw (SFPException)remoteException.detail;
                }
                throw new SFPException("0003", remoteException.detail);
            }
            throw new SFPException("0003", remoteException);
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "ServiceableEvent.updateAttribute() caught Exception: " + exception);
            throw new SFPException("0003", exception);
        }
        Trace.trace(TRACE_MASKF, "ServiceableEvent.updateAttribute() updated attribute; resetting data in local ServicableEvent");
        this.reset(serviceableEvent);
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.updateAttribute()");
    }

    public boolean refreshFromServer(MOClass mOClass) {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.refreshFromServer()");
        Object[] objectArray = new Object[]{this.getResourceHandle()};
        boolean bl = false;
        try {
            ServiceableEvent serviceableEvent = (ServiceableEvent)mOClass.invokeStaticMethod("getServiceableEvent", objectArray);
            this.reset(serviceableEvent);
            bl = true;
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "ServiceableEvent.refreshFromServer() event not refreshed; caught exception " + exception);
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.refreshFromServer()");
        return bl;
    }

    private static CtDataType[] getArrayAttributeValue(McAttribute mcAttribute) {
        CtDataType[] ctDataTypeArray = ((CtArray)ServiceableEvent.getAttributeValue(mcAttribute)).getData();
        return ctDataTypeArray;
    }

    private static int getIntegerAttributeValue(McAttribute mcAttribute) {
        int n = ((CtUint32)ServiceableEvent.getAttributeValue(mcAttribute)).getJniData();
        return n;
    }

    private static String getStringAttributeValue(McAttribute mcAttribute) {
        String string = ((CtString)ServiceableEvent.getAttributeValue(mcAttribute)).getData();
        return string;
    }

    private static boolean getBooleanAttributeValue(McAttribute mcAttribute) {
        String string = ServiceableEvent.getStringAttributeValue(mcAttribute);
        boolean bl = YES.equalsIgnoreCase(string);
        return bl;
    }

    private static CtStructuredData getStructuredDataAttributeValue(McAttribute mcAttribute) {
        CtStructuredData ctStructuredData = (CtStructuredData)ServiceableEvent.getAttributeValue(mcAttribute);
        return ctStructuredData;
    }

    private static CtRsrcHandle getResourceHandleAttributeValue(McAttribute mcAttribute) {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.getResourceHandleAttributeValue()");
        CtRsrcHandle ctRsrcHandle = (CtRsrcHandle)ServiceableEvent.getAttributeValue(mcAttribute);
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.getResourceHandleAttributeValue()");
        return ctRsrcHandle;
    }

    private static CtDataType getAttributeValue(McAttribute mcAttribute) {
        if (mcAttribute == null) {
            Trace.trace(TRACE_MASKF, "ServiceableEvent.getAttributeValue() retrieved a null value");
        }
        CtDataType ctDataType = mcAttribute.getValue();
        return ctDataType;
    }

    public void addListener(ServiceableEventListener serviceableEventListener) {
        if (!this.listeners.contains(serviceableEventListener)) {
            this.listeners.add(serviceableEventListener);
        }
    }

    public void removeListener(ServiceableEventListener serviceableEventListener) {
        this.listeners.remove(serviceableEventListener);
    }

    public void removeAllListeners() {
        this.listeners.removeAllElements();
    }

    private void notifyListeners() {
        Trace.trace(TRACE_MASKT, "->ServiceableEvent.notifyListeners()");
        int n = this.listeners.size();
        int n2 = 0;
        while (n2 < n) {
            ServiceableEventListener serviceableEventListener = (ServiceableEventListener)this.listeners.elementAt(n2);
            if (serviceableEventListener != null) {
                serviceableEventListener.serviceableEventUpdated(this);
            }
            ++n2;
        }
        Trace.trace(TRACE_MASKT, "<-ServiceableEvent.notifyListeners()");
    }
}

